*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file updated for Nids Wave 4

* THIS IS 8th INCOME DO FILE - RELEASE DO FILE: 7 OF 7
* THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

*=====================================================================================================================================

* OPENING DATASET CREATED IN DO FILE "Income - Aggregation of post-imputation variables (6 of 7)"

use "$DataOUT\hhdata.dta", clear

foreach var of varlist hhq_incb fwag cwag swag cheq prof extr bonu othe help  ///
ppen uif comp indi inhe rnt retr brid gift loan sale remt {
rename `var'_data `var'_flg
}

keep pid w4_hhid hhsizer hhincome* hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag_imp cwag_imp swag_imp ///
cheq_imp prof_imp extr_imp bonu_imp othe_imp help_imp spen ppen_imp uif comp_imp dis ///
chld fost cdep indi_imp inhe_imp rnt_imp retr_imp brid_imp gift_imp loan_imp sale_imp remt_imp fwag_flg ///
cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg ///
dis_flg chld_flg fost_flg cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg ///
remt_flg 
sort w4_hhid

rename *_imp * 

*Renaming 
foreach x of varlist hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag cwag swag ///
cheq prof extr bonu othe help  spen ppen uif comp dis chld fost cdep indi inhe ///
rnt retr brid gift loan sale remt ///
fwag_flg cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg ///
othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg dis_flg chld_flg fost_flg ///
cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg remt_flg {
rename `x' w4_`x'
}

save "$DataOUT\temp.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* HOUSEHOLD LEVEL RELEASE

use "$DataOUT\temp.dta", clear
keep w4_hhid w4_hhsizer w4_hhq_inc w4_hhq_incb w4_hhq_incb_flg w4_hhincome ///
w4_hhincome_flg w4_hhwage w4_hhgovt w4_hhother w4_hhinvest w4_hhcapital w4_hhremitt ///
w4_hhimprent w4_hhimprent_flg w4_hhagric w4_pi_hhincome w4_pi_hhwage w4_pi_hhgovt ///
w4_pi_hhother w4_pi_hhinvest w4_pi_hhcapital w4_pi_hhremitt w4_pi_hhagric w4_pi_hhimprent
sort w4_hhid
drop if w4_hhid==w4_hhid[_n-1]

sort w4_hhid
save "$DataOUT\release.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* INDIVIDUAL LEVEL RELEASE

use "$DataOUT\temp.dta", clear

keep pid w4_hhid w4_fwag w4_cwag w4_swag w4_cheq w4_prof w4_extr w4_bonu w4_othe ///
w4_help w4_spen w4_ppen w4_uif w4_comp w4_dis w4_chld w4_fost w4_cdep w4_indi w4_inhe ///
w4_rnt w4_retr w4_brid w4_gift w4_loan w4_sale w4_remt w4_fwag_flg w4_cwag_flg w4_swag_flg ///
w4_cheq_flg w4_prof_flg w4_extr_flg w4_bonu_flg w4_othe_flg w4_help_flg w4_spen_flg ///
w4_ppen_flg w4_uif_flg w4_comp_flg w4_dis_flg w4_chld_flg w4_fost_flg w4_cdep_flg w4_indi_flg ///
w4_inhe_flg w4_rnt_flg w4_retr_flg w4_brid_flg w4_gift_flg w4_loan_flg w4_sale_flg w4_remt_flg

order pid w4_hhid w4_fwag w4_cwag w4_swag w4_cheq w4_prof w4_extr w4_bonu w4_othe w4_help ///
w4_spen w4_ppen w4_uif w4_comp w4_dis w4_chld w4_fost w4_cdep w4_indi w4_inhe w4_rnt w4_retr ///
w4_brid w4_gift w4_loan w4_sale w4_remt w4_fwag_flg w4_cwag_flg w4_swag_flg w4_cheq_flg ///
w4_prof_flg w4_extr_flg w4_bonu_flg w4_othe_flg w4_help_flg w4_spen_flg w4_ppen_flg ///
w4_uif_flg w4_comp_flg w4_dis_flg w4_chld_flg w4_fost_flg w4_cdep_flg w4_indi_flg w4_inhe_flg ///
w4_rnt_flg w4_retr_flg w4_brid_flg w4_gift_flg w4_loan_flg w4_sale_flg w4_remt_flg

lab var w4_fwag "Monthly take home pay from primary and secondary jobs"
lab var w4_cwag "Monthly take home pay from casual work"
lab var w4_swag "Monthly income from self-employment"
lab var w4_cheq "Income from 13th cheque"
lab var w4_prof "Income from profit share"
lab var w4_extr "Monthly income from extra payment on a piece-rate basis"
lab var w4_bonu "Income from other bonuses from main job"
lab var w4_othe "Monthly income from other sources"
lab var w4_help "Monthly income from helping friends"
lab var w4_ppen "Monthly income from private/foriegn penion pension and retirement annuities"
lab var w4_uif "Monthly income from UIF payments"
lab var w4_comp "Monthly income from workmen's compensation"
lab var w4_indi "Monthly income from interest and dividends"
lab var w4_inhe "Monthly income from inheritances"
lab var w4_rnt "Monthly income from rentals"
lab var w4_retr "Monthly income from retrenchment payments"
lab var w4_brid "Monthly income from lobola/bridal payments"
lab var w4_gift "Monthly income from gifts"
lab var w4_loan "Monthly 'income' from loan repayments"
lab var w4_sale "Monthly 'income' from sale of household assets"
lab var w4_remt "Monthly income from remittance payments"
lab var w4_fwag_flg "Net wage data flag"
lab var w4_cwag_flg "Casual wage data flag"
lab var w4_swag_flg "Self employment wage data flag"
lab var w4_cheq_flg "13th cheque data flag"
lab var w4_prof_flg "Profit share data flag"
lab var w4_extr_flg "Extra piece-rate payment data flag"
lab var w4_bonu_flg "Bonus income data flag"
lab var w4_othe_flg "Income from other sources data flag"
lab var w4_help_flg "Help income data flag"
lab var w4_ppen_flg "Private pension/retirement annuity data flag"
lab var w4_uif_flg "UIF income data flag"
lab var w4_comp_flg "Workmen's compensation data flag"
lab var w4_indi_flg "Interest and dividend income data flag"
lab var w4_inhe_flg "Inheritance income data flag"
lab var w4_rnt_flg "Rental income data flag"
lab var w4_retr_flg "Retrenchment income data flag"
lab var w4_brid_flg "Lobola/bridal income data flag"
lab var w4_gift_flg "Gift income data flag"
lab var w4_loan_flg "Loan repayment income data flag"
lab var w4_sale_flg "Sale of household assets data flag"
lab var w4_remt_flg "Remittance income data flag"

sort pid
save "$DataOUT\release_indiv.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* FINAL RELEASE FILES

clear
use "$DataOUT\temp.dta", clear

sort w4_hhid
merge m:1 w4_hhid using "$DataOUT\release.dta"
drop _merge
sort w4_hhid
drop if w4_hhid==w4_hhid[_n-1]
compress

keep w4_hhid w4_hhsizer w4_hhq_inc w4_hhq_incb w4_hhq_incb_flg w4_hhincome w4_hhincome_flg ///
w4_hhwage w4_hhgovt w4_hhother w4_hhinvest w4_hhcapital w4_hhremitt w4_hhimprent w4_hhimprent_flg ///
w4_pi_hhincome w4_pi_hhwage w4_pi_hhgovt w4_pi_hhother w4_pi_hhinvest w4_pi_hhcapital ///
w4_pi_hhremitt w4_pi_hhagric w4_hhagric w4_pi_hhimprent

order w4_hhid  /*w4_hhprov w4_hhgeo w4_hhdc w4_hhcluster w4_wgt w4_dwgt w4_wgt_p1 w4_dwgt_p1 w4_dtwgt_p1*/ ///
/*w4_dtwgt*/ w4_hhsizer w4_hhq_inc w4_hhq_incb w4_hhq_incb_flg w4_hhincome w4_hhincome_flg ///
w4_hhwage w4_hhgovt w4_hhother w4_hhinvest w4_hhcapital w4_hhremitt w4_hhimprent w4_hhimprent_flg ///
w4_hhagric w4_pi_hhincome w4_pi_hhwage w4_pi_hhgovt w4_pi_hhother w4_pi_hhinvest w4_pi_hhcapital ///
w4_pi_hhremitt w4_pi_hhagric w4_pi_hhimprent

lab var w4_hhq_incb_flg "The household income as per household questionnaire data"
lab var w4_hhagric "Household average monthly income from subsistence agriculture"

compress
save "$DataOUT\hhderived_INCOME", replace
erase "$DataOUT\temp.dta"

*Individual derived

use "$DataOUT\release_indiv.dta", clear
order pid w4_hhid
compress
duplicates drop pid, force
save "$DataOUT\indderived_INCOME", replace

erase "$DataOUT\data.dta"
capture erase "$DataOUT\temp.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\hhdata.dta"
erase "$DataOUT\release.dta"
erase "$DataOUT\release_indiv.dta"

* end of do file
*==================================================================================================================================================

